/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.certificate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.metadata.certificate.ServerCertificate;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/signal/libsignal/metadata/certificate/CertificateValidator;", "", "trustRoots", "", "Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "<init>", "(Ljava/util/List;)V", "trustRoot", "(Lorg/signal/libsignal/protocol/ecc/ECPublicKey;)V", "getTrustRoots", "()Ljava/util/List;", "validate", "", "certificate", "Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "validationTime", "", "Lorg/signal/libsignal/metadata/certificate/ServerCertificate;", "libsignal-client"})
@SourceDebugExtension(value={"SMAP\nCertificateValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificateValidator.kt\norg/signal/libsignal/metadata/certificate/CertificateValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1761#2,3:71\n1563#2:74\n1634#2,3:75\n*S KotlinDebug\n*F\n+ 1 CertificateValidator.kt\norg/signal/libsignal/metadata/certificate/CertificateValidator\n*L\n65#1:71,3\n38#1:74\n38#1:75,3\n*E\n"})
public class CertificateValidator {
    @NotNull
    private final List<ECPublicKey> trustRoots;

    public CertificateValidator(@NotNull List<ECPublicKey> trustRoots) {
        Intrinsics.checkNotNullParameter(trustRoots, (String)"trustRoots");
        this.trustRoots = trustRoots;
    }

    @NotNull
    public final List<ECPublicKey> getTrustRoots() {
        return this.trustRoots;
    }

    public CertificateValidator(@NotNull ECPublicKey trustRoot) {
        Intrinsics.checkNotNullParameter((Object)trustRoot, (String)"trustRoot");
        this(CollectionsKt.listOf((Object)trustRoot));
    }

    public void validate(@NotNull SenderCertificate certificate, long validationTime) throws InvalidCertificateException {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        try {
            certificate.guardedRun(arg_0 -> CertificateValidator.validate$lambda$0(this, validationTime, arg_0));
        }
        catch (InvalidCertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidCertificateException(e);
        }
    }

    public final void validate(@NotNull ServerCertificate certificate) throws InvalidCertificateException {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Iterable $this$any$iv = this.trustRoots;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ECPublicKey it = (ECPublicKey)element$iv;
                    boolean bl2 = false;
                    if (!it.verifySignature(certificate.getCertificate(), certificate.getSignature())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            throw new InvalidCertificateException("All signatures failed");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void validate$lambda$0(CertificateValidator this$0, long $validationTime, long certificateHandle) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.trustRoots;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ECPublicKey eCPublicKey = (ECPublicKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.unsafeNativeHandleWithoutGuard());
        }
        long[] trustRootHandles = CollectionsKt.toLongArray((Collection)((List)destination$iv$iv));
        if (!Native.SenderCertificate_Validate(certificateHandle, trustRootHandles, $validationTime)) {
            throw new InvalidCertificateException("Validation failed");
        }
    }
}

