/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.messagebackup;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import kotlin.Pair;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.messagebackup.MessageBackupKey;
import org.signal.libsignal.messagebackup.ValidationError;

public class MessageBackup {
    public static ValidationResult validate(MessageBackupKey key, Purpose purpose, Supplier<InputStream> streamFactory, long streamLength) throws ValidationError, IOException {
        Pair result;
        try (InputStream first = streamFactory.get();
             InputStream second = streamFactory.get();
             NativeHandleGuard keyGuard = new NativeHandleGuard(key);){
            Pair outputPair;
            Object output = FilterExceptions.filterExceptions(IOException.class, ValidationError.class, () -> Native.MessageBackupValidator_Validate(keyGuard.nativeHandle(), first, second, streamLength, purpose.ordinal()));
            result = outputPair = (Pair)output;
        }
        String errorMessage = (String)result.getFirst();
        if (errorMessage != null) {
            throw new ValidationError(errorMessage, (String[])result.getSecond());
        }
        return new ValidationResult((String[])result.getSecond());
    }

    public static enum Purpose {
        DEVICE_TRANSFER,
        REMOTE_BACKUP;

    }

    public static class ValidationResult {
        public String[] unknownFieldMessages;

        public ValidationResult(String[] unknownFieldMessages) {
            this.unknownFieldMessages = unknownFieldMessages;
        }
    }
}

