/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.state.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.signal.libsignal.protocol.InvalidKeyIdException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.ReusedBaseKeyException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.signal.libsignal.protocol.state.KyberPreKeyStore;
import org.signal.libsignal.protocol.util.Pair;

public class InMemoryKyberPreKeyStore
implements KyberPreKeyStore {
    private final Map<Integer, byte[]> store = new HashMap<Integer, byte[]>();
    private final Set<Integer> used = new HashSet<Integer>();
    private final Map<Pair<Integer, Integer>, Set<ECPublicKey>> baseKeysSeen = new HashMap<Pair<Integer, Integer>, Set<ECPublicKey>>();

    @Override
    public KyberPreKeyRecord loadKyberPreKey(int kyberPreKeyId) throws InvalidKeyIdException {
        try {
            if (!this.store.containsKey(kyberPreKeyId)) {
                throw new InvalidKeyIdException("No such KyberPreKeyRecord! " + kyberPreKeyId);
            }
            return new KyberPreKeyRecord(this.store.get(kyberPreKeyId));
        }
        catch (InvalidMessageException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public List<KyberPreKeyRecord> loadKyberPreKeys() {
        try {
            LinkedList<KyberPreKeyRecord> results = new LinkedList<KyberPreKeyRecord>();
            for (byte[] serialized : this.store.values()) {
                results.add(new KyberPreKeyRecord(serialized));
            }
            return results;
        }
        catch (InvalidMessageException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void storeKyberPreKey(int kyberPreKeyId, KyberPreKeyRecord record) {
        this.store.put(kyberPreKeyId, record.serialize());
    }

    @Override
    public boolean containsKyberPreKey(int kyberPreKeyId) {
        return this.store.containsKey(kyberPreKeyId);
    }

    @Override
    public void markKyberPreKeyUsed(int kyberPreKeyId, int signedPreKeyId, ECPublicKey baseKey) throws ReusedBaseKeyException {
        this.used.add(kyberPreKeyId);
        Pair<Integer, Integer> bothKeyIds = new Pair<Integer, Integer>(kyberPreKeyId, signedPreKeyId);
        Set<ECPublicKey> baseKeysSeen = this.baseKeysSeen.get(bothKeyIds);
        if (baseKeysSeen == null) {
            this.baseKeysSeen.put(bothKeyIds, new HashSet<ECPublicKey>(Arrays.asList(baseKey)));
        } else if (!baseKeysSeen.add(baseKey)) {
            throw new ReusedBaseKeyException();
        }
    }

    public boolean hasKyberPreKeyBeenUsed(int kyberPreKeyId) {
        return this.used.contains(kyberPreKeyId);
    }
}

