/*
 * Fooyin
 * Copyright © 2024, Luke Taylor <LukeT1@proton.me>
 *
 * Fooyin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fooyin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fooyin.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#pragma once

#include "waveformdata.h"

#include <utils/database/dbmodule.h>

namespace Fooyin {
class Track;

namespace WaveBar {
class WaveBarDatabase : public DbModule
{
public:
    void initialiseDatabase() const;

    [[nodiscard]] bool existsInCache(const QString& key) const;
    [[nodiscard]] bool loadCachedData(const QString& key, WaveformData<int16_t>& data) const;
    [[nodiscard]] bool storeInCache(const QString& key, const WaveformData<int16_t>& data) const;
    [[nodiscard]] bool removeFromCache(const QString& key) const;
    [[nodiscard]] bool removeFromCache(const QStringList& keys) const;
    [[nodiscard]] bool clearCache() const;

    static QString cacheKey(const Track& track);
    static QString cacheKey(const Track& track, int channels);
};
} // namespace WaveBar
} // namespace Fooyin
