
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was FooyinConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/fooyin" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

list(APPEND CMAKE_MODULE_PATH ${CMAKE_CURRENT_LIST_DIR}/modules)

find_package(Qt6 NO_MODULE REQUIRED COMPONENTS Core Widgets Sql Concurrent Network)
find_package(Taglib REQUIRED taglib>=1.12)
find_package(ALSA REQUIRED)
find_package(SDL2)
find_package(
    FFmpeg REQUIRED
    COMPONENTS AVCODEC
               AVFORMAT
               AVUTIL
               AVDEVICE
               AVFILTER
               SWSCALE
               SWRESAMPLE
)

set(FOOYIN_PLUGIN_VERSION 0.0)
set(FOOYIN_PLUGIN_INSTALL_DIR ${PACKAGE_PREFIX_DIR}/lib/fooyin/plugins)

include("${CMAKE_CURRENT_LIST_DIR}/FooyinTargets.cmake")
include("${CMAKE_CURRENT_LIST_DIR}/FooyinMacros.cmake")
