/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.KeyStore;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.res.StringManager;

class Jre8Compat
extends JreCompat {
    private static final Log log;
    private static final StringManager sm;
    private static final int RUNTIME_MAJOR_VERSION = 8;
    private static final Method setUseCipherSuitesOrderMethod;
    private static final Constructor<?> domainLoadStoreParameterConstructor;
    protected static final Method setApplicationProtocolsMethod;
    protected static final Method getApplicationProtocolMethod;

    Jre8Compat() {
    }

    static boolean isSupported() {
        return setUseCipherSuitesOrderMethod != null;
    }

    @Override
    public void setUseServerCipherSuitesOrder(SSLParameters sSLParameters, boolean bl) {
        try {
            setUseCipherSuitesOrderMethod.invoke((Object)sSLParameters, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException(invocationTargetException);
        }
    }

    @Override
    public KeyStore.LoadStoreParameter getDomainLoadStoreParameter(URI uRI) {
        try {
            return (KeyStore.LoadStoreParameter)domainLoadStoreParameterConstructor.newInstance(uRI, Collections.EMPTY_MAP);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            throw new UnsupportedOperationException(exception);
        }
    }

    @Override
    public int jarFileRuntimeMajorVersion() {
        return 8;
    }

    @Override
    public void setApplicationProtocols(SSLParameters sSLParameters, String[] stringArray) {
        if (setApplicationProtocolsMethod != null) {
            try {
                setApplicationProtocolsMethod.invoke((Object)sSLParameters, new Object[]{stringArray});
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                throw new UnsupportedOperationException(exception);
            }
        } else {
            super.setApplicationProtocols(sSLParameters, stringArray);
        }
    }

    @Override
    public String getApplicationProtocol(SSLEngine sSLEngine) {
        if (getApplicationProtocolMethod != null) {
            try {
                return (String)getApplicationProtocolMethod.invoke((Object)sSLEngine, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                throw new UnsupportedOperationException(exception);
            }
        }
        return super.getApplicationProtocol(sSLEngine);
    }

    public static boolean isAlpnSupported() {
        return setApplicationProtocolsMethod != null && getApplicationProtocolMethod != null;
    }

    static {
        GenericDeclaration genericDeclaration;
        GenericDeclaration genericDeclaration2;
        log = LogFactory.getLog(Jre8Compat.class);
        sm = StringManager.getManager(Jre8Compat.class);
        Method method = null;
        Constructor<?> constructor = null;
        try {
            genericDeclaration2 = Class.forName("javax.net.ssl.SSLParameters");
            method = genericDeclaration2.getMethod("setUseCipherSuitesOrder", Boolean.TYPE);
            genericDeclaration = Class.forName("java.security.DomainLoadStoreParameter");
            constructor = genericDeclaration.getConstructor(URI.class, Map.class);
        }
        catch (SecurityException securityException) {
            log.error((Object)sm.getString("jre8Compat.unexpected"), (Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (method == null) {
                log.debug((Object)sm.getString("jre8Compat.javaPre8"), (Throwable)noSuchMethodException);
            } else {
                log.error((Object)sm.getString("jre8Compat.unexpected"), (Throwable)noSuchMethodException);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error((Object)sm.getString("jre8Compat.unexpected"), (Throwable)classNotFoundException);
        }
        setUseCipherSuitesOrderMethod = method;
        domainLoadStoreParameterConstructor = constructor;
        genericDeclaration2 = null;
        genericDeclaration = null;
        try {
            genericDeclaration2 = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
            genericDeclaration = SSLEngine.class.getMethod("getApplicationProtocol", new Class[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            // empty catch block
        }
        setApplicationProtocolsMethod = genericDeclaration2;
        getApplicationProtocolMethod = genericDeclaration;
    }
}

