/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.layout;

import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.layout.Alignment;
import com.jogamp.graph.ui.layout.Gap;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Vec3f;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.util.PMVMatrix;
import java.util.List;

public class GridLayout
implements Group.Layout {
    private final Order order;
    private final int col_limit;
    private final int row_limit;
    private final float cellWidth;
    private final float cellHeight;
    private final Alignment alignment;
    private final Gap gap;
    private int row_count;
    private int col_count;
    private static final boolean TRACE_LAYOUT = false;

    public GridLayout(int n, float f, float f2, Alignment alignment) {
        this(alignment, Math.max(1, n), -1, f, f2, new Gap());
    }

    public GridLayout(int n, float f, float f2, Alignment alignment, Gap gap) {
        this(alignment, Math.max(1, n), -1, f, f2, gap);
    }

    public GridLayout(float f, float f2, Alignment alignment, Gap gap, int n) {
        this(alignment, -1, Math.max(1, n), f, f2, gap);
    }

    private GridLayout(Alignment alignment, int n, int n2, float f, float f2, Gap gap) {
        this.order = 0 < n ? Order.COLUMN : Order.ROW;
        this.col_limit = n;
        this.row_limit = n2;
        this.cellWidth = f;
        this.cellHeight = f2;
        this.alignment = alignment;
        this.gap = gap;
        this.row_count = 0;
        this.col_count = 0;
    }

    public Order getOrder() {
        return this.order;
    }

    public int getColumnCount() {
        return this.col_count;
    }

    public int getRowCount() {
        return this.row_count;
    }

    public Gap getGap() {
        return this.gap;
    }

    @Override
    public void layout(Group group, AABBox aABBox, PMVMatrix pMVMatrix) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        AABBox aABBox2;
        Shape shape;
        int n;
        Vec3f vec3f = new Vec3f();
        boolean bl = !FloatUtil.isZero(this.cellWidth);
        boolean bl2 = !FloatUtil.isZero(this.cellHeight);
        boolean bl3 = bl && this.alignment.isSet(Alignment.Bit.Center);
        boolean bl4 = bl2 && this.alignment.isSet(Alignment.Bit.Center);
        boolean bl5 = this.alignment.isSet(Alignment.Bit.Fill) && (bl || bl2);
        List<Shape> list = group.getShapes();
        if (Order.COLUMN == this.order) {
            this.row_count = (int)Math.ceil((double)list.size() / (double)this.col_limit);
            this.col_count = this.col_limit;
        } else {
            this.row_count = this.row_limit;
            this.col_count = (int)Math.ceil((double)list.size() / (double)this.row_limit);
        }
        int n2 = 0;
        int n3 = 0;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = -3.4028235E38f;
        float f10 = -3.4028235E38f;
        AABBox[] aABBoxArray = new AABBox[list.size()];
        float[] fArray = new float[this.col_count * this.row_count];
        for (n = 0; n < list.size(); ++n) {
            float f11;
            shape = list.get(n);
            pMVMatrix.glPushMatrix();
            shape.setTransform(pMVMatrix);
            aABBox2 = shape.getBounds();
            aABBoxArray[n] = aABBox2.transformMv(pMVMatrix, new AABBox());
            pMVMatrix.glPopMatrix();
            aABBox2 = aABBoxArray[n];
            if (bl5) {
                f11 = aABBox2.getWidth();
                f6 = aABBox2.getHeight();
                f5 = bl ? this.cellWidth : f11;
                f4 = bl2 ? this.cellHeight : f6;
                f3 = f5 / f11;
                f2 = f4 / f6;
                f = f3 < f2 ? f3 : f2;
            } else {
                f = 1.0f;
            }
            f11 = f * aABBox2.getWidth();
            f6 = f * aABBox2.getHeight();
            f5 = bl ? this.cellWidth : f11;
            f4 = bl2 ? this.cellHeight : f6;
            f3 = f8 + f4;
            f2 = f7 + f5;
            f10 = Math.max(f10, f3);
            f9 = Math.max(f9, f2);
            fArray[this.col_count * n3 + n2] = f3;
            if (n + 1 >= list.size()) continue;
            if (Order.COLUMN == this.order) {
                if (n2 + 1 == this.col_count) {
                    n2 = 0;
                    ++n3;
                    f7 = 0.0f;
                    f8 += f4 + this.gap.height();
                    continue;
                }
                ++n2;
                f7 += f5 + this.gap.width();
                continue;
            }
            if (n3 + 1 == this.row_count) {
                n3 = 0;
                ++n2;
                f8 = 0.0f;
                f7 += f5 + this.gap.width();
                continue;
            }
            ++n3;
            f8 += f4 + this.gap.height();
        }
        n3 = 0;
        n2 = 0;
        f7 = 0.0f;
        f8 = 0.0f;
        for (n = 0; n < list.size(); ++n) {
            float f12;
            float f13;
            float f14;
            float f15;
            shape = list.get(n);
            aABBox2 = aABBoxArray[n];
            f = aABBox2.getCenter().z();
            Vec3f vec3f2 = new Vec3f();
            AABBox aABBox3 = shape.getBounds();
            if (!vec3f2.set(aABBox3.getLow().x(), aABBox3.getLow().y(), 0.0f).min(vec3f).isZero()) {
                Vec3f vec3f3 = shape.getScale();
                vec3f2.scale(-1.0f * vec3f3.x(), -1.0f * vec3f3.y(), 0.0f);
            }
            f5 = 0.0f;
            f4 = 0.0f;
            if (bl5) {
                f3 = aABBox2.getWidth();
                f2 = aABBox2.getHeight();
                f15 = bl ? this.cellWidth : f3;
                f14 = bl2 ? this.cellHeight : f2;
                f13 = f15 / f3;
                f12 = f14 / f2;
                f6 = f13 < f12 ? f13 : f12;
                f5 += f3 * (f13 - f6) * 0.5f;
                f4 += f2 * (f12 - f6) * 0.5f;
            } else {
                f6 = 1.0f;
            }
            f3 = f6 * aABBox2.getWidth();
            f2 = f6 * aABBox2.getHeight();
            f15 = bl ? this.cellWidth : f3;
            f14 = bl2 ? this.cellHeight : f2;
            f8 = f10 - fArray[this.col_count * n3 + n2];
            if (bl3) {
                f5 += 0.5f * (f15 - f3);
            }
            if (bl4) {
                f4 += 0.5f * (f14 - f2);
            }
            f13 = f7 + f5;
            f12 = f8 + f4;
            shape.moveTo(f13, f12, 0.0f);
            shape.move(vec3f2.scale(f6));
            aABBox.resize(f7, f8, f);
            aABBox.resize(f13 + f15, f12 + f14, f);
            shape.scale(f6, f6, 1.0f);
            if (n + 1 >= list.size()) continue;
            if (Order.COLUMN == this.order) {
                if (n2 + 1 == this.col_count) {
                    n2 = 0;
                    ++n3;
                    f7 = 0.0f;
                    continue;
                }
                ++n2;
                f7 += f15 + this.gap.width();
                continue;
            }
            if (n3 + 1 == this.row_count) {
                n3 = 0;
                ++n2;
                f8 = 0.0f;
                f7 += f15 + this.gap.width();
                continue;
            }
            ++n3;
        }
    }

    public String toString() {
        return "Grid[" + this.col_count + "x" + this.row_count + ", " + (Object)((Object)this.order) + ", cell[" + this.cellWidth + " x " + this.cellHeight + ", a " + this.alignment + "], " + this.gap + "]";
    }

    public static enum Order {
        COLUMN,
        ROW;

    }
}

