/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.Transformation;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;

public class ModelMaterialsController
implements Controller {
    private final String title;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final PropertyChangeSupport propertyChangeSupport;
    private View materialsChoiceView;
    private TextureChoiceController textureController;
    private Content model;
    private String modelCreator;
    private float modelWidth;
    private float modelDepth;
    private float modelHeight;
    private float[][] modelRotation;
    private Transformation[] modelTransformations;
    private int modelFlags;
    private HomeMaterial[] materials;

    public ModelMaterialsController(String string, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this.title = string;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public View getView() {
        if (this.materialsChoiceView == null) {
            this.materialsChoiceView = this.viewFactory.createModelMaterialsView(this.preferences, this);
        }
        return this.materialsChoiceView;
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void setModel(Content content) {
        if (this.model != content) {
            Content content2 = this.model;
            this.model = content;
            this.propertyChangeSupport.firePropertyChange(Property.MODEL.name(), content2, content);
        }
    }

    public Content getModel() {
        return this.model;
    }

    public void setModelCreator(String string) {
        this.modelCreator = string;
    }

    public String getModelCreator() {
        return this.modelCreator;
    }

    void setModelRotation(float[][] fArray) {
        this.modelRotation = fArray;
    }

    public float[][] getModelRotation() {
        return this.modelRotation;
    }

    void setModelTransformations(Transformation[] transformationArray) {
        this.modelTransformations = transformationArray;
    }

    public Transformation[] getModelTransformations() {
        return this.modelTransformations;
    }

    void setModelSize(float f, float f2, float f3) {
        this.modelWidth = f;
        this.modelDepth = f2;
        this.modelHeight = f3;
    }

    public float getModelWidth() {
        return this.modelWidth;
    }

    public float getModelDepth() {
        return this.modelDepth;
    }

    public float getModelHeight() {
        return this.modelHeight;
    }

    void setBackFaceShown(boolean bl) {
        this.setModelFlags(this.getModelFlags() & 0xFFFFFFFE | (bl ? 1 : 0));
    }

    public boolean isBackFaceShown() {
        return (this.modelFlags & 1) == 1;
    }

    public void setModelFlags(int n) {
        this.modelFlags = n;
    }

    public int getModelFlags() {
        return this.modelFlags;
    }

    public void setMaterials(HomeMaterial[] homeMaterialArray) {
        if (!Arrays.equals(this.materials, homeMaterialArray)) {
            HomeMaterial[] homeMaterialArray2 = this.materials;
            this.materials = homeMaterialArray;
            this.propertyChangeSupport.firePropertyChange(Property.MATERIALS.name(), homeMaterialArray2, homeMaterialArray);
        }
    }

    public HomeMaterial[] getMaterials() {
        return this.materials;
    }

    public String getDialogTitle() {
        return this.title;
    }

    public TextureChoiceController getTextureController() {
        if (this.textureController == null) {
            this.textureController = new TextureChoiceController(this.preferences.getLocalizedString(ModelMaterialsController.class, "textureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
        }
        return this.textureController;
    }

    public static enum Property {
        MODEL,
        MATERIALS;

    }
}

