/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.QuadPoint;
import net.osmand.util.GeoPointParserUtil;

public class MapUtils {
    private static final String BASE_SHORT_OSM_URL = "https://openstreetmap.org/go/";
    private static final char[] intToBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '~'};

    public static double getDistance(LatLon l, double latitude, double longitude) {
        return MapUtils.getDistance(l.getLatitude(), l.getLongitude(), latitude, longitude);
    }

    private static double scalarMultiplication(double xA, double yA, double xB, double yB, double xC, double yC) {
        return (xB - xA) * (xC - xA) + (yB - yA) * (yC - yA);
    }

    public static double getOrthogonalDistance(double lat, double lon, double fromLat, double fromLon, double toLat, double toLon) {
        return MapUtils.getDistance(MapUtils.getProjection(lat, lon, fromLat, fromLon, toLat, toLon), lat, lon);
    }

    public static double getOrthogonalDistance(LatLon latLon, LatLon fromLatLon, LatLon toLatLon) {
        return MapUtils.getDistance(MapUtils.getProjection(latLon.getLatitude(), latLon.getLongitude(), fromLatLon.getLatitude(), fromLatLon.getLongitude(), toLatLon.getLatitude(), toLatLon.getLongitude()), latLon.getLatitude(), latLon.getLongitude());
    }

    public static LatLon getProjection(double lat, double lon, double fromLat, double fromLon, double toLat, double toLon) {
        double prlon;
        double prlat;
        double mDist = (fromLat - toLat) * (fromLat - toLat) + (fromLon - toLon) * (fromLon - toLon);
        double projection = MapUtils.scalarMultiplication(fromLat, fromLon, toLat, toLon, lat, lon);
        if (projection < 0.0) {
            prlat = fromLat;
            prlon = fromLon;
        } else if (projection >= mDist) {
            prlat = toLat;
            prlon = toLon;
        } else {
            prlat = fromLat + (toLat - fromLat) * (projection / mDist);
            prlon = fromLon + (toLon - fromLon) * (projection / mDist);
        }
        return new LatLon(prlat, prlon);
    }

    public static double getProjectionCoeff(double lat, double lon, double fromLat, double fromLon, double toLat, double toLon) {
        double mDist = (fromLat - toLat) * (fromLat - toLat) + (fromLon - toLon) * (fromLon - toLon);
        double projection = MapUtils.scalarMultiplication(fromLat, fromLon, toLat, toLon, lat, lon);
        if (projection < 0.0) {
            return 0.0;
        }
        if (projection >= mDist) {
            return 1.0;
        }
        return projection / mDist;
    }

    private static double toRadians(double angdeg) {
        return angdeg / 180.0 * Math.PI;
    }

    public static double getDistance(double lat1, double lon1, double lat2, double lon2) {
        double R2 = 6372.8;
        double dLat = MapUtils.toRadians(lat2 - lat1);
        double dLon = MapUtils.toRadians(lon2 - lon1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(MapUtils.toRadians(lat1)) * Math.cos(MapUtils.toRadians(lat2)) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        return 2.0 * R2 * 1000.0 * Math.asin(Math.sqrt(a));
    }

    public static double getDistance(LatLon l1, LatLon l2) {
        return MapUtils.getDistance(l1.getLatitude(), l1.getLongitude(), l2.getLatitude(), l2.getLongitude());
    }

    public static double checkLongitude(double longitude) {
        if (longitude > -180.0 && longitude <= 180.0) {
            return longitude;
        }
        while (longitude < -180.0 || longitude > 180.0) {
            if (longitude < 0.0) {
                longitude += 360.0;
                continue;
            }
            longitude -= 360.0;
        }
        return longitude;
    }

    public static double checkLatitude(double latitude) {
        if (latitude > -80.0 && latitude <= 80.0) {
            return latitude;
        }
        while (latitude < -90.0 || latitude > 90.0) {
            if (latitude < 0.0) {
                latitude += 180.0;
                continue;
            }
            latitude -= 180.0;
        }
        if (latitude < -85.0511) {
            return -85.0511;
        }
        if (latitude > 85.0511) {
            return 85.0511;
        }
        return latitude;
    }

    public static int get31TileNumberX(double longitude) {
        longitude = MapUtils.checkLongitude(longitude);
        long l = 0x80000000L;
        return (int)((longitude + 180.0) / 360.0 * (double)l);
    }

    public static int get31TileNumberY(double latitude) {
        latitude = MapUtils.checkLatitude(latitude);
        double eval = Math.log(Math.tan(MapUtils.toRadians(latitude)) + 1.0 / Math.cos(MapUtils.toRadians(latitude)));
        long l = 0x80000000L;
        if (eval > Math.PI) {
            eval = Math.PI;
        }
        return (int)((1.0 - eval / Math.PI) / 2.0 * (double)l);
    }

    public static double get31LongitudeX(int tileX) {
        return MapUtils.getLongitudeFromTile(21.0, (float)tileX / 1024.0f);
    }

    public static double get31LatitudeY(int tileY) {
        return MapUtils.getLatitudeFromTile(21.0f, (float)tileY / 1024.0f);
    }

    public static double getTileNumberX(float zoom, double longitude) {
        double powZoom;
        double dz = ((longitude = MapUtils.checkLongitude(longitude)) + 180.0) / 360.0 * (powZoom = MapUtils.getPowZoom(zoom));
        if (dz >= powZoom) {
            return powZoom - 0.01;
        }
        return dz;
    }

    public static double getTileNumberY(float zoom, double latitude) {
        double eval = Math.log(Math.tan(MapUtils.toRadians(latitude = MapUtils.checkLatitude(latitude))) + 1.0 / Math.cos(MapUtils.toRadians(latitude)));
        if (Double.isInfinite(eval) || Double.isNaN(eval)) {
            latitude = latitude < 0.0 ? -89.9 : 89.9;
            eval = Math.log(Math.tan(MapUtils.toRadians(latitude)) + 1.0 / Math.cos(MapUtils.toRadians(latitude)));
        }
        return (1.0 - eval / Math.PI) / 2.0 * MapUtils.getPowZoom(zoom);
    }

    public static double getTileEllipsoidNumberY(float zoom, double latitude) {
        double E2 = latitude * Math.PI / 180.0;
        long sradiusa = 6378137L;
        long sradiusb = 6356752L;
        double J2 = Math.sqrt(2.72335601265E11) / 6378137.0;
        double M2 = Math.log((1.0 + Math.sin(E2)) / (1.0 - Math.sin(E2))) / 2.0 - J2 * Math.log((1.0 + J2 * Math.sin(E2)) / (1.0 - J2 * Math.sin(E2))) / 2.0;
        double B2 = MapUtils.getPowZoom(zoom);
        return B2 / 2.0 - M2 * B2 / 2.0 / Math.PI;
    }

    public static double getLatitudeFromEllipsoidTileY(float zoom, float tileNumberY) {
        double MerkElipsK = 1.0E-7;
        long sradiusa = 6378137L;
        long sradiusb = 6356752L;
        double FExct = Math.sqrt(2.72335601265E11) / 6378137.0;
        double TilesAtZoom = MapUtils.getPowZoom(zoom);
        double result = ((double)tileNumberY - TilesAtZoom / 2.0) / -(TilesAtZoom / (Math.PI * 2));
        result = (2.0 * Math.atan(Math.exp(result)) - 1.5707963267948966) * 180.0 / Math.PI;
        double Zu = result / 57.29577951308232;
        double yy = (double)tileNumberY - TilesAtZoom / 2.0;
        double Zum1 = Zu;
        Zu = Math.asin(1.0 - (1.0 + Math.sin(Zum1)) * Math.pow(1.0 - FExct * Math.sin(Zum1), FExct) / (Math.exp(2.0 * yy / -(TilesAtZoom / (Math.PI * 2))) * Math.pow(1.0 + FExct * Math.sin(Zum1), FExct)));
        while (Math.abs(Zum1 - Zu) >= 1.0E-7) {
            Zum1 = Zu;
            Zu = Math.asin(1.0 - (1.0 + Math.sin(Zum1)) * Math.pow(1.0 - FExct * Math.sin(Zum1), FExct) / (Math.exp(2.0 * yy / -(TilesAtZoom / (Math.PI * 2))) * Math.pow(1.0 + FExct * Math.sin(Zum1), FExct)));
        }
        return Zu * 180.0 / Math.PI;
    }

    public static double getTileDistanceWidth(float zoom) {
        LatLon ll = new LatLon(30.0, MapUtils.getLongitudeFromTile(zoom, 0.0));
        LatLon ll2 = new LatLon(30.0, MapUtils.getLongitudeFromTile(zoom, 1.0));
        return MapUtils.getDistance(ll, ll2);
    }

    public static double getLongitudeFromTile(double zoom, double x) {
        return x / MapUtils.getPowZoom(zoom) * 360.0 - 180.0;
    }

    public static double getPowZoom(double zoom) {
        if (zoom >= 0.0 && zoom - Math.floor(zoom) < (double)0.001f) {
            return 1 << (int)zoom;
        }
        return Math.pow(2.0, zoom);
    }

    public static float calcDiffPixelX(float rotateSin, float rotateCos, float dTileX, float dTileY, float tileSize) {
        return (rotateCos * dTileX - rotateSin * dTileY) * tileSize;
    }

    public static float calcDiffPixelY(float rotateSin, float rotateCos, float dTileX, float dTileY, float tileSize) {
        return (rotateSin * dTileX + rotateCos * dTileY) * tileSize;
    }

    public static double getLatitudeFromTile(float zoom, double y) {
        int sign = y < 0.0 ? -1 : 1;
        return Math.atan((double)sign * Math.sinh(Math.PI * (1.0 - 2.0 * y / MapUtils.getPowZoom(zoom)))) * 180.0 / Math.PI;
    }

    public static int getPixelShiftX(float zoom, double long1, double long2, double tileSize) {
        return (int)((MapUtils.getTileNumberX(zoom, long1) - MapUtils.getTileNumberX(zoom, long2)) * tileSize);
    }

    public static int getPixelShiftY(float zoom, double lat1, double lat2, double tileSize) {
        return (int)((MapUtils.getTileNumberY(zoom, lat1) - MapUtils.getTileNumberY(zoom, lat2)) * tileSize);
    }

    public static void sortListOfMapObject(List<? extends MapObject> list, final double lat, final double lon) {
        Collections.sort(list, new Comparator<MapObject>(){

            @Override
            public int compare(MapObject o1, MapObject o2) {
                return Double.compare(MapUtils.getDistance(o1.getLocation(), lat, lon), MapUtils.getDistance(o2.getLocation(), lat, lon));
            }
        });
    }

    public static String buildGeoUrl(double latitude, double longitude, int zoom) {
        return "geo:" + (float)latitude + "," + (float)longitude + "?z=" + zoom;
    }

    public static String buildShortOsmUrl(double latitude, double longitude, int zoom) {
        return BASE_SHORT_OSM_URL + MapUtils.createShortLinkString(latitude, longitude, zoom) + "?m";
    }

    public static String createShortLinkString(double latitude, double longitude, int zoom) {
        long lat = (long)((latitude + 90.0) / 180.0 * 4.294967296E9);
        long lon = (long)((longitude + 180.0) / 360.0 * 4.294967296E9);
        long code = MapUtils.interleaveBits(lon, lat);
        String str = "";
        int i = 0;
        while ((double)i < Math.ceil((double)(zoom + 8) / 3.0)) {
            str = str + intToBase64[(int)(code >> 58 - 6 * i & 0x3FL)];
            ++i;
        }
        for (int j = 0; j < (zoom + 8) % 3; ++j) {
            str = str + '-';
        }
        return str;
    }

    public static GeoPointParserUtil.GeoParsedPoint decodeShortLinkString(String s) {
        s = s.replaceAll("@", "~");
        int i = 0;
        long x = 0L;
        long y = 0L;
        int z = -8;
        for (i = 0; i < s.length(); ++i) {
            int j;
            int digit = -1;
            char c = s.charAt(i);
            for (j = 0; j < intToBase64.length; ++j) {
                if (c != intToBase64[j]) continue;
                digit = j;
                break;
            }
            if (digit < 0 || digit < 0) break;
            x <<= 3;
            y <<= 3;
            for (j = 2; j >= 0; --j) {
                x |= (long)((digit & 1 << j + j + 1) == 0 ? 0 : 1 << j);
                y |= (long)((digit & 1 << j + j) == 0 ? 0 : 1 << j);
            }
            z += 3;
        }
        double lon = (double)x * Math.pow(2.0, 2 - 3 * i) * 90.0 - 180.0;
        double lat = (double)y * Math.pow(2.0, 2 - 3 * i) * 45.0 - 90.0;
        if (i < s.length() && s.charAt(i) == '-') {
            z -= 2;
            if (i + 1 < s.length() && s.charAt(i + 1) == '-') {
                ++z;
            }
        }
        return new GeoPointParserUtil.GeoParsedPoint(lat, lon, z);
    }

    private static long interleaveBits(long x, long y) {
        long c = 0L;
        for (int b = 31; b >= 0; b = (int)((byte)(b - 1))) {
            c = c << 1 | x >> b & 1L;
            c = c << 1 | y >> b & 1L;
        }
        return c;
    }

    public static float unifyRotationDiff(float rotate, float targetRotate) {
        float d;
        for (d = targetRotate - rotate; d >= 180.0f; d -= 360.0f) {
        }
        while (d < -180.0f) {
            d += 360.0f;
        }
        return d;
    }

    public static float unifyRotationTo360(float rotate) {
        while (rotate < -180.0f) {
            rotate += 360.0f;
        }
        while (rotate > 180.0f) {
            rotate -= 360.0f;
        }
        return rotate;
    }

    public static double alignAngleDifference(double diff) {
        while (diff > Math.PI) {
            diff -= Math.PI * 2;
        }
        while (diff <= -Math.PI) {
            diff += Math.PI * 2;
        }
        return diff;
    }

    public static double degreesDiff(double a1, double a2) {
        double diff;
        for (diff = a1 - a2; diff > 180.0; diff -= 360.0) {
        }
        while (diff <= -180.0) {
            diff += 360.0;
        }
        return diff;
    }

    public static double convert31YToMeters(double y1, double y2) {
        return (y1 - y2) * 0.01863;
    }

    public static double convert31XToMeters(double x1, double x2) {
        return (x1 - x2) * 0.011;
    }

    public static QuadPoint getProjectionPoint31(int px, int py, int st31x, int st31y, int end31x, int end31y) {
        double projection = MapUtils.calculateProjection31TileMetric(st31x, st31y, end31x, end31y, px, py);
        double mDist = MapUtils.squareRootDist31(end31x, end31y, st31x, st31y);
        int pry = end31y;
        int prx = end31x;
        if (projection < 0.0) {
            prx = st31x;
            pry = st31y;
        } else if (projection >= mDist * mDist) {
            prx = end31x;
            pry = end31y;
        } else {
            prx = (int)((double)st31x + (double)(end31x - st31x) * (projection / (mDist * mDist)));
            pry = (int)((double)st31y + (double)(end31y - st31y) * (projection / (mDist * mDist)));
        }
        return new QuadPoint(prx, pry);
    }

    public static double squareRootDist31(int x1, int y1, int x2, int y2) {
        double dy = MapUtils.convert31YToMeters(y1, y2);
        double dx = MapUtils.convert31XToMeters(x1, x2);
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double measuredDist31(int x1, int y1, int x2, int y2) {
        return MapUtils.getDistance(MapUtils.get31LatitudeY(y1), MapUtils.get31LongitudeX(x1), MapUtils.get31LatitudeY(y2), MapUtils.get31LongitudeX(x2));
    }

    public static double squareDist31TileMetric(int x1, int y1, int x2, int y2) {
        double dy = MapUtils.convert31YToMeters(y1, y2);
        double dx = MapUtils.convert31XToMeters(x1, x2);
        return dx * dx + dy * dy;
    }

    public static double calculateProjection31TileMetric(int xA, int yA, int xB, int yB, int xC, int yC) {
        double multiple = MapUtils.convert31XToMeters(xB, xA) * MapUtils.convert31XToMeters(xC, xA) + MapUtils.convert31YToMeters(yB, yA) * MapUtils.convert31YToMeters(yC, yA);
        return multiple;
    }

    public static boolean rightSide(double lat, double lon, double aLat, double aLon, double bLat, double bLon) {
        double ax = aLon - lon;
        double by = bLat - lat;
        double bx = bLon - lon;
        double ay = aLat - lat;
        double sa = ax * by - bx * ay;
        return sa < 0.0;
    }
}

