/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.apiguardian.api.API;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.engine.discovery.predicates.IsTestableMethod;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

@API(status=API.Status.INTERNAL, since="5.0")
public class IsTestFactoryMethod
extends IsTestableMethod {
    private static final String EXPECTED_RETURN_TYPE_MESSAGE = String.format("must return a single %1$s or a Stream, Collection, Iterable, Iterator, Iterator provider, or array of %1$s", DynamicNode.class.getName());

    public IsTestFactoryMethod(DiscoveryIssueReporter issueReporter) {
        super(TestFactory.class, IsTestFactoryMethod::hasCompatibleReturnType, issueReporter);
    }

    private static DiscoveryIssueReporter.Condition<Method> hasCompatibleReturnType(Class<? extends Annotation> annotationType, DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(method -> IsTestFactoryMethod.isCompatible(method, issueReporter), method -> IsTestFactoryMethod.createIssue(annotationType, method, EXPECTED_RETURN_TYPE_MESSAGE));
    }

    private static boolean isCompatible(Method method, DiscoveryIssueReporter issueReporter) {
        Class<?> returnType = method.getReturnType();
        if (DynamicNode.class.isAssignableFrom(returnType) || DynamicNode[].class.isAssignableFrom(returnType)) {
            return true;
        }
        if (returnType == Object.class || returnType == Object[].class) {
            issueReporter.reportIssue(IsTestFactoryMethod.createTooGenericReturnTypeIssue(method));
            return true;
        }
        boolean validContainerType = !returnType.isArray() && CollectionUtils.isConvertibleToStream(returnType);
        return validContainerType && IsTestFactoryMethod.isCompatibleContainerType(method, issueReporter);
    }

    private static boolean isCompatibleContainerType(Method method, DiscoveryIssueReporter issueReporter) {
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments();
            if (typeArguments.length == 1) {
                Type typeArgument = typeArguments[0];
                if (typeArgument instanceof Class) {
                    return DynamicNode.class.isAssignableFrom((Class)typeArgument);
                }
                if (typeArgument instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)typeArgument;
                    Type[] upperBounds = wildcardType.getUpperBounds();
                    Type[] lowerBounds = wildcardType.getLowerBounds();
                    if (upperBounds.length == 1 && lowerBounds.length == 0 && upperBounds[0] instanceof Class) {
                        Class upperBound = (Class)upperBounds[0];
                        if (Object.class.equals((Object)upperBound)) {
                            issueReporter.reportIssue(IsTestFactoryMethod.createTooGenericReturnTypeIssue(method));
                            return true;
                        }
                        return DynamicNode.class.isAssignableFrom(upperBound);
                    }
                }
            }
            return false;
        }
        issueReporter.reportIssue(IsTestFactoryMethod.createTooGenericReturnTypeIssue(method));
        return true;
    }

    private static DiscoveryIssue.Builder createTooGenericReturnTypeIssue(Method method) {
        String message = String.format("The declared return type of @TestFactory method '%s' does not support static validation. It " + EXPECTED_RETURN_TYPE_MESSAGE + ".", method.toGenericString());
        return DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.INFO, (String)message).source((TestSource)MethodSource.from((Method)method));
    }
}

