/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class RemoveRaftVoterRequestData
implements ApiMessage {
    String clusterId;
    int voterId;
    Uuid voterDirectoryId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The cluster id of the request."), new Field("voter_id", Type.INT32, "The replica id of the voter getting removed from the topic partition."), new Field("voter_directory_id", Type.UUID, "The directory id of the voter getting removed from the topic partition."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public RemoveRaftVoterRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public RemoveRaftVoterRequestData() {
        this.clusterId = "";
        this.voterId = 0;
        this.voterDirectoryId = Uuid.ZERO_UUID;
    }

    @Override
    public short apiKey() {
        return 81;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.clusterId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clusterId had invalid length " + length);
            }
            this.clusterId = _readable.readString(length);
        }
        this.voterId = _readable.readInt();
        this.voterDirectoryId = _readable.readUuid();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (this.clusterId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue(this.clusterId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeInt(this.voterId);
        _writable.writeUuid(this.voterDirectoryId);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (this.clusterId == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clusterId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clusterId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(4);
        _size.addBytes(16);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoveRaftVoterRequestData)) {
            return false;
        }
        RemoveRaftVoterRequestData other = (RemoveRaftVoterRequestData)obj;
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.voterId != other.voterId) {
            return false;
        }
        if (!this.voterDirectoryId.equals(other.voterDirectoryId)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + this.voterId;
        hashCode = 31 * hashCode + this.voterDirectoryId.hashCode();
        return hashCode;
    }

    @Override
    public RemoveRaftVoterRequestData duplicate() {
        RemoveRaftVoterRequestData _duplicate = new RemoveRaftVoterRequestData();
        _duplicate.clusterId = this.clusterId == null ? null : this.clusterId;
        _duplicate.voterId = this.voterId;
        _duplicate.voterDirectoryId = this.voterDirectoryId;
        return _duplicate;
    }

    public String toString() {
        return "RemoveRaftVoterRequestData(clusterId=" + (String)(this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", voterId=" + this.voterId + ", voterDirectoryId=" + this.voterDirectoryId.toString() + ")";
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int voterId() {
        return this.voterId;
    }

    public Uuid voterDirectoryId() {
        return this.voterDirectoryId;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RemoveRaftVoterRequestData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public RemoveRaftVoterRequestData setVoterId(int v) {
        this.voterId = v;
        return this;
    }

    public RemoveRaftVoterRequestData setVoterDirectoryId(Uuid v) {
        this.voterDirectoryId = v;
        return this;
    }
}

